package gov.va.vamf.scheduling.facility.timezone;

import gov.va.vamf.scheduling.direct.domain.Namespace;
import org.springframework.data.annotation.Id;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.FIELD)
@XmlRootElement(namespace = Namespace.Facility, name = "facility-timezone")
public class FacilityTimezone {
    @Id
    @XmlElement
    private String id;
    @XmlElement
    private String name;
    @XmlElement
    private String timezone;
    @XmlElement
    private String currentTZ;

    public FacilityTimezone() {
    }

    public FacilityTimezone(String id, String name, String timezone) {
        this.id = id;
        this.name = name;
        this.timezone = timezone;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getCurrentTZ() {
        return currentTZ;
    }

    public void setCurrentTZ(String currentTZ) {
        this.currentTZ = currentTZ;
    }
}
